#include <struct.h>
//------------------------------------------------------------------
// Cube Tool goes here.

DWORD CALLBACK CubePreMode(tProcParams* params)
{
  CurrentState.SetState(
    Z3D_STATE_WAITFOR_FIRSTCLICK);
  return 0;
}

DWORD CALLBACK CubeOnLButtonDown(tProcParams* params)
{
  // the tool doesn't support Mapper view.
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_MAPPER)
    return 0;

  // if we are still expecting first click,
  // then we've got it. Now wait for second one.
  if (CurrentState.IsState(
    Z3D_STATE_WAITFOR_FIRSTCLICK))
  {
    CurrentState.SetState(
      Z3D_STATE_WAITFOR_SECONDCLICK);
    return 0;
  }

  //Ok, create the Cube.
  tPOINT  Center =  (*params->LastPressedAt);
  float  fEdge = Dist3D(
    params->ProcessedLocation->x,
    params->ProcessedLocation->y,
    params->ProcessedLocation->z,
    params->LastPressedAt->x,
    params->LastPressedAt->y,
    params->LastPressedAt->z)/1.42f;
  if (fEdge < MINFLOAT)
  {
    AfxMessageBox("Too small cube!");
    return 0;
  }

  tObject* pCube = new tObject("Cube",
    8,
    12);
  pCube->VertTable->Table[0].X = Center.x-fEdge;
  pCube->VertTable->Table[0].Y = Center.y-fEdge;
  pCube->VertTable->Table[0].Z = Center.z-fEdge;

  pCube->VertTable->Table[1].X = Center.x+fEdge;
  pCube->VertTable->Table[1].Y = Center.y-fEdge;
  pCube->VertTable->Table[1].Z = Center.z-fEdge;

  pCube->VertTable->Table[2].X = Center.x+fEdge;
  pCube->VertTable->Table[2].Y = Center.y+fEdge;
  pCube->VertTable->Table[2].Z = Center.z-fEdge;

  pCube->VertTable->Table[3].X = Center.x-fEdge;
  pCube->VertTable->Table[3].Y = Center.y+fEdge;
  pCube->VertTable->Table[3].Z = Center.z-fEdge;

  pCube->VertTable->Table[4].X = Center.x-fEdge;
  pCube->VertTable->Table[4].Y = Center.y-fEdge;
  pCube->VertTable->Table[4].Z = Center.z+fEdge;

  pCube->VertTable->Table[5].X = Center.x+fEdge;
  pCube->VertTable->Table[5].Y = Center.y-fEdge;
  pCube->VertTable->Table[5].Z = Center.z+fEdge;

  pCube->VertTable->Table[6].X = Center.x+fEdge;
  pCube->VertTable->Table[6].Y = Center.y+fEdge;
  pCube->VertTable->Table[6].Z = Center.z+fEdge;

  pCube->VertTable->Table[7].X = Center.x-fEdge;
  pCube->VertTable->Table[7].Y = Center.y+fEdge;
  pCube->VertTable->Table[7].Z = Center.z+fEdge;

  int i;
  for (i = 0; i < 8; i++)
  {
    pCube->VertTable->Table[i].NormalX = 0.547f*sgn(pCube->VertTable->Table[i].X-Center.x);
    pCube->VertTable->Table[i].NormalY = 0.547f*sgn(pCube->VertTable->Table[i].Y-Center.y);
    pCube->VertTable->Table[i].NormalZ = 0.547f*sgn(pCube->VertTable->Table[i].Z-Center.z);
  }

  for (i = 0; i < 4; i++)
  {
    pCube->FaceTable->Table[i*2].I1 = i;
    pCube->FaceTable->Table[i*2].I2 = 4+i;
    pCube->FaceTable->Table[i*2].I3 = (i+1)%4;
    pCube->FaceTable->Table[i*2+1].I1 = 4+i;
    pCube->FaceTable->Table[i*2+1].I2 = 4+(i+1)%4;
    pCube->FaceTable->Table[i*2+1].I3 = (i+1)%4;
  }
  //caps:
  for (i = 0; i < 4; i+=2)
  {
    pCube->FaceTable->Table[8+i/2].I1 = i;
    pCube->FaceTable->Table[8+i/2].I2 = (i+1)%4;
    pCube->FaceTable->Table[8+i/2].I3 = (i+2)%4;
    pCube->FaceTable->Table[8+i/2+2].I1 = 4+i;
    pCube->FaceTable->Table[8+i/2+2].I2 = 4+(i+2)%4;
    pCube->FaceTable->Table[8+i/2+2].I3 = 4+(i+1)%4;
  }

  pCube->nRequire = Z3D_PLUGRESULT_REDRAW;

  params->Objects->AddObject(pCube);
  delete pCube;

  CurrentState.SetState(Z3D_STATE_WAITFOR_FIRSTCLICK);
  return Z3D_PLUGRESULT_VIEWSREDRAW;
}

DWORD CALLBACK CubeOnMouseMove(tProcParams* params)
{
  // if we are still expecting first click,
  // then do nothing - user simply moves the
  // mouse currently.
  if (!CurrentState.IsState(
    Z3D_STATE_WAITFOR_SECONDCLICK))
    return 0;

  // the tool doesn's support UVMapper view
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_MAPPER)
    return 0;

  // if we got here, we are expecting for the second
  // click. So, draw the circular shape:

  float  fEdge;
  int    iEdge;
  fEdge = Dist3D(
    params->ProcessedLocation->x,
    params->ProcessedLocation->y,
    params->ProcessedLocation->z,
    params->LastPressedAt->x,
    params->LastPressedAt->y,
    params->LastPressedAt->z);
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_USER)
    iEdge = (int)(fEdge*(
      (params->ViewDesc->ClientRect.bottom - params->ViewDesc->ClientRect.top)/
      (2.0f*tan(params->ViewDesc->CamFOV/360.0f*M_PI)*params->ViewDesc->Zoom*1.42f)));//1.42 is ~sqrt(2)
  else
    iEdge = (int)(fEdge*params->ViewDesc->Zoom/1.42f);//1.42 is ~sqrt(2)
  POINT center = ConvertToScreen(
    params->LastPressedAt->x,
    params->LastPressedAt->y,
    params->LastPressedAt->z,
    params->ViewDesc);
  params->pdc->SelectStockObject(NULL_BRUSH);
  params->pdc->SelectObject((CPen*)Global.PenThinBlueCreate);

  params->pdc->Rectangle(
    center.x-iEdge,
    center.y-iEdge,
    center.x+iEdge,
    center.y+iEdge);
  params->pdc->SelectObject((CPen*)Global.PenThinBlack);
  return  Z3D_PLUGRESULT_MANUALDRAW |
      Z3D_PLUGRESULT_NOCOVER;
}
